<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('timestamps', 'softDeletes');

    public function materials()
    {
        return $this->belongsToMany('Material', 'service_material', 'service_id', 'material_id')->withTimestamps();
    }

}